--[[
LuCI - Lua Configuration Interface
]]--

require("luci.sys")
sys = require "luci.sys"
local uci = require "luci.model.uci".cursor()
require("luci.util")

m = Map("dhcp", translate("Mofi Family Shield"))

s1 = m:section(TypedSection, "dnsmasq", "Global Settings")
s1.anonymous = true
s1.addremove = false

mode = s1:option(Flag, "famlyshield", translate("Apply Family Shield to All Devices: "))
mode.default="0"
mode.rmempty = false

function mode.write(self, section, value)
	if value == "1" then
		luci.sys.call('uci set network.lan.dns="208.67.222.123 208.67.220.123"')
		luci.sys.call("uci -q set network.lan.forcedns=1")
		luci.sys.call("uci -q set network.lan.pushclient=1")
		luci.sys.call("uci commit network")
	else
		luci.sys.call('uci set network.lan.dns="8.8.8.8 4.2.2.2"')
		luci.sys.call("uci -q delete network.lan.forcedns")
		luci.sys.call("uci -q delete network.lan.pushclient")
		luci.sys.call("uci commit network")
	end
	Value.write(self, section, value)
end


s = m:section(TypedSection, "host", translate("Family Shield"))
s.addremove = true
s.anonymous = true
s.template = "cbi/tblsection"
s.defaults.tag='shield'

hn = s:option(Value, "name", translate("Name"))
hn.datatype = "hostname"
hn.rmempty  = true

mac = s:option(Value, "mac", translate("<abbr title=\"Media Access Control\">MAC</abbr>-Address"))

ip = s:option(Value, "ip", translate("IP address"))
ip.datatype = "ipaddr"
ip.rmempty  = true

sys.net.arptable(function(entry)
	ip:value(entry["IP address"])
	mac:value(
		entry["HW address"],
		entry["HW address"] .. " (" .. entry["IP address"] .. ")"
	)
end)

enable = s:option(ListValue, "enable", translate("Enable"))
enable:value("0", "OFF")
enable:value("1", "ON")
enable.default="1"

return m

