--[[
LuCI - Lua Configuration Interface
]]--

require("luci.sys")
m = Map("opendns", translate("OpenDNS"), translate("This will Update and Setup OpenDNS Content Filtering"))
s = m:section(NamedSection, "config")

dummy = s:option(DummyValue, "dummy", "")
dummy.template = "cbi/tvalue"
dummy.rows = 4

function dummy.cfgvalue()
return "NOTE: A OpenDNS Account is required to use this service\r\
Please Visit their website and create an account and enter the username and password that was used to create as well as the Network Name to update.\r"
end

en1 = s:option(Flag, "enabled", translate("Enabled "))
en1.rmempty = false
en1.enabled = "1"
en1.disabled = "0"

function en1.write(self, section, value)
        if value == "1" then
                luci.sys.call("/sbin/opendnssetup.sh 1 >/dev/null")
        else
                luci.sys.call("/sbin/opendnssetup.sh 0 >/dev/null")
        end
		return Flag.write(self, section, value)
end

user = s:option(Value, "username", translate("OpenDNS Username: "))
pass = s:option(Value, "password", translate("OpenDNS Password: "))
pass.password = true

network = s:option(Value, "network", translate("OpenDNS Network: "))

family = s:option(Value, "dns", translate("Select OpenDNS Servers: "))
family:value("208.67.222.222 208.67.220.220", "Normal: 208.67.222.222 208.67.220.220")
family:value("208.67.222.123 208.67.220.123", "FamilyShield: 208.67.222.123 208.67.220.123")
family.default="208.67.222.222 208.67.220.220"

return m

