require("luci.tools.webadmin")
local uci = require "luci.model.uci".cursor_state()
local sys = require "luci.sys"

m = Map("ipdomainfilter", "IP Domain Whitelist Or Filter")

s = m:section(TypedSection, "domainfilter", translate("Domain Whitelist/Filter"))                                                                                            
s.anonymous = true                                                                                                                                                      
s.addremove = false                                                                                                                                                     
                                                                                                                                                                                        
o = s:option(Flag, "enable", translate("Enable"))                                                                                                            
o.rmempty = false

o = s:option(ListValue, "domain_white_enable", translate("Domain Whitelist or Blacklist"))                                                                                                            
o:value(0, translate("Black List"))
o:value(1, translate("White List"))



o = s:option(DynamicList, "domain", translate("Domain Name"))
o:depends("enable", "1") 

--IP FILTER
s = m:section(TypedSection, "ipfilter", translate("IP Whitelist/Filter"))                                                                                            
s.anonymous = true                                                                                                                                                      
s.addremove = false                                                                                                                                                     
                                                                                                                                                                                        
o = s:option(Flag, "enable", translate("Enable"))                                                                                                            
o.rmempty = false

o = s:option(ListValue, "ip_white_enable", translate("IP Whitelist or Blacklist"))                                                                                                            
o:value(0, translate("Black List"))
o:value(1, translate("White List"))

o = s:option(DynamicList, "ip", translate("IP Address"))
o:depends("enable", "1") 
o.datatype = "neg(ip4addr)"

local apply = luci.http.formvalue("cbi.apply")
if apply then
         io.popen("/etc/init.d/ipdomainfilter restart")
end

return m

