#!/bin/sh

remove_job() {
	local PATTERN="$1"
	
	#sed '/'$PATTERN'/d' /etc/crontabs/root > /etc/crontabs/root.new
	sed '/\<'$PATTERN'\>/d' /etc/crontabs/root > /etc/crontabs/root.new
	mv  /etc/crontabs/root.new /etc/crontabs/root # atomic update.
}

add_job() {
	local LINE="$1"

	SCHED=$(echo "${LINE}" | cut -d " " -f 1-5)
	COMMAND=$(echo "${LINE}" | cut -d " " -f 6-)

	[ -z "$SCHED" -o -z "$COMMAND" ] && return 0
	check=$(grep -i "$COMMAND" /etc/crontabs/root)
	if [ -n "$check" ]; then
		return 0
	fi

	crontab -l >crontab.tmp
	printf '%s\n' "$SCHED $COMMAND" >>crontab.tmp
	crontab crontab.tmp && rm -f crontab.tmp

	# wipes out cronjob
	#(crontab -l 2>/dev/null; grep -sq '$COMMAND' /etc/crontabs/root || echo "$SCHED $COMMAND") | crontab -
}

# grep -sq /usr/bin/alerts /etc/crontabs/root || echo "*/1 * * * *  /usr/bin/alerts" >> /etc/crontabs/root
#(crontab -l 2>/dev/null; echo "0 4 * * * myscript")| crontab -
#(crontab -l 2>/dev/null; echo "0 4 * * * myscript")| crontab -
#(crontab -l 2>/dev/null; echo "0 4 * * * myscript")| crontab -
#(crontab -l 2>/dev/null; grep -sq /usr/bin/alerts /etc/crontabs/root || echo "*/1 * * * *  /usr/bin/alerts")| crontab -

#add_job "* * * * *" "/usr/bin/alerts"
#add_job "0 2 * * *" "/usr/bin/alerts2323"

#echo listing...
#cat /etc/crontabs/root

#sleep 2

#echo now remove
#remove_job "alerts"
#remove_job "myscript"

#crontab -l >crontab.tmp
#printf '%s\n' "$1" >>crontab.tmp
#crontab crontab.tmp && rm -f crontab.tmp

