/*
 * Decompiled with CFR 0.152.
 */
package net.nlanr.jperf.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.Properties;
import net.nlanr.jperf.core.IperfSpeedUnit;
import net.nlanr.jperf.core.IperfUnit;
import net.nlanr.jperf.core.TosOption;

public class IPerfProperties {
    public static final String KEY_MODE = "mode";
    public static final String DEFAULT_MODE = "client";
    public static final String KEY_SERVER_ADDRESS = "server-address";
    public static final String DEFAULT_SERVER_ADDRESS = "";
    public static final String KEY_SERVER_PORT = "server-port";
    public static final int DEFAULT_SERVER_PORT = 5001;
    public static final String KEY_PARALLEL_STREAMS = "serverside-parallel-streams";
    public static final int DEFAULT_PARALLEL_STREAMS = 1;
    public static final String KEY_LISTEN_PORT = "listen-port";
    public static final int DEFAULT_LISTEN_PORT = 5001;
    public static final String KEY_CLIENT_LIMIT = "client-limit";
    public static final String DEFAULT_CLIENT_LIMIT = "";
    public static final String KEY_CLIENT_LIMIT_ENABLED = "client-limit-enabled";
    public static final boolean DEFAULT_CLIENT_LIMIT_ENABLED = false;
    public static final String KEY_NUM_CONNECTIONS = "clientside-parallel-streams";
    public static final int DEFAULT_NUM_CONNECTIONS = 0;
    public static final String KEY_TTL = "ttl";
    public static final int DEFAULT_TTL = 1;
    public static final String KEY_TOS = "tos";
    public static final TosOption DEFAULT_TOS = TosOption.NONE;
    public static final String KEY_BIND_TO_HOST = "bind-to-host";
    public static final String DEFAULT_BIND_TO_HOST = "";
    public static final String KEY_IPV6_ENABLED = "ipv6-enabled";
    public static final boolean DEFAULT_IPV6_ENABLED = false;
    public static final String KEY_TRANSPORT_PROTOCOL = "transport-protocol";
    public static final String DEFAULT_TRANSPORT_PROTOCOL = "tcp";
    public static final String KEY_TCP_BUFFER_LENGTH = "tcp-buffer-length";
    public static final double DEFAULT_TCP_BUFFER_LENGTH = 2.0;
    public static final String KEY_TCP_BUFFER_LENGTH_UNIT = "tcp-buffer-length-unit";
    public static final IperfUnit DEFAULT_TCP_BUFFER_LENGTH_UNIT = IperfUnit.MBYTES;
    public static final String KEY_TCP_BUFFER_LENGTH_ENABLED = "tcp-buffer-length-enabled";
    public static final boolean DEFAULT_TCP_BUFFER_LENGTH_ENABLED = false;
    public static final String KEY_TCP_WINDOW_SIZE = "tcp-window-size";
    public static final double DEFAULT_TCP_WINDOW_SIZE = 56.0;
    public static final String KEY_TCP_WINDOW_SIZE_UNIT = "tcp-window-size-unit";
    public static final IperfUnit DEFAULT_TCP_WINDOW_SIZE_UNIT = IperfUnit.KBYTES;
    public static final String KEY_TCP_WINDOW_SIZE_ENABLED = "tcp-window-size-enabled";
    public static final boolean DEFAULT_TCP_WINDOW_SIZE_ENABLED = false;
    public static final String KEY_TCP_MSS = "tcp-mss";
    public static final double DEFAULT_TCP_MSS = 1.0;
    public static final String KEY_TCP_MSS_UNIT = "tcp-mss-unit";
    public static final IperfUnit DEFAULT_TCP_MSS_UNIT = IperfUnit.KBYTES;
    public static final String KEY_TCP_MSS_ENABLED = "tcp-mss-enabled";
    public static final boolean DEFAULT_TCP_MSS_ENABLED = false;
    public static final String KEY_TCP_NO_DELAY_ENABLED = "tcp-no-delay-enabled";
    public static final boolean DEFAULT_TCP_NO_DELAY_ENABLED = false;
    public static final String KEY_UDP_BANDWIDTH = "udp-bandwidth";
    public static final double DEFAULT_UDP_BANDWIDTH = 1.0;
    public static final String KEY_UDP_BANDWIDTH_UNIT = "udp-bandwidth-unit";
    public static final IperfSpeedUnit DEFAULT_UDP_BANDWIDTH_UNIT = IperfSpeedUnit.MEGABYTES_PERSEC;
    public static final String KEY_UDP_BUFFER_SIZE = "udp-buffer-size";
    public static final double DEFAULT_UDP_BUFFER_SIZE = 41.0;
    public static final String KEY_UDP_BUFFER_SIZE_UNIT = "udp-buffer-size-unit";
    public static final IperfUnit DEFAULT_UDP_BUFFER_SIZE_UNIT = IperfUnit.KBYTES;
    public static final String KEY_UDP_BUFFER_SIZE_ENABLED = "udp-buffer-size-enabled";
    public static final boolean DEFAULT_UDP_BUFFER_SIZE_ENABLED = false;
    public static final String KEY_UDP_PACKET_SIZE = "udp-packet-size";
    public static final double DEFAULT_UDP_PACKET_SIZE = 1500.0;
    public static final String KEY_UDP_PACKET_SIZE_UNIT = "udp-packet-size-unit";
    public static final IperfUnit DEFAULT_UDP_PACKET_SIZE_UNIT = IperfUnit.BYTES;
    public static final String KEY_UDP_PACKET_SIZE_ENABLED = "udp-packet-size-enabled";
    public static final boolean DEFAULT_UDP_PACKET_SIZE_ENABLED = false;
    public static final String KEY_COMPATIBILITY_MODE_ENABLED = "compatibility-mode-enabled";
    public static final boolean DEFAULT_COMPATIBILITY_MODE_ENABLED = false;
    public static final String KEY_TRANSMIT = "transmit-value";
    public static final int DEFAULT_TRANSMIT = 10;
    public static final String KEY_TRANSMIT_UNIT = "transmit-unit";
    public static final String DEFAULT_TRANSMIT_UNIT = "seconds";
    public static final String KEY_OUTPUT_FORMAT = "output-format";
    public static final IperfUnit DEFAULT_OUTPUT_FORMAT = IperfUnit.KBITS;
    public static final String KEY_REPORT_INTERVAL = "report-interval";
    public static final int DEFAULT_REPORT_INTERVAL = 1;
    public static final String KEY_TEST_MODE_DUAL_ENABLED = "test-mode-dual-enabled";
    public static final boolean DEFAULT_TEST_MODE_DUAL_ENABLED = false;
    public static final String KEY_TEST_MODE_TRADE_ENABLED = "test-mode-trade-enabled";
    public static final boolean DEFAULT_TEST_MODE_TRADE_ENABLED = false;
    public static final String KEY_TEST_MODE_PORT = "test-mode-port";
    public static final int DEFAULT_TEST_MODE_PORT = 5001;
    public static final String KEY_PRINT_MSS_ENABLED = "print-mss-enabled";
    public static final boolean DEFAULT_PRINT_MSS_ENABLED = false;
    private Properties properties = new Properties();

    public IPerfProperties(boolean bl) {
        if (bl) {
            this.put(KEY_MODE, DEFAULT_MODE);
            this.put(KEY_SERVER_ADDRESS, "");
            this.put(KEY_SERVER_PORT, 5001);
            this.put(KEY_PARALLEL_STREAMS, 1);
            this.put(KEY_LISTEN_PORT, 5001);
            this.put(KEY_CLIENT_LIMIT, "");
            this.put(KEY_CLIENT_LIMIT_ENABLED, false);
            this.put(KEY_NUM_CONNECTIONS, 0);
            this.put(KEY_TTL, 1);
            this.put(KEY_TOS, DEFAULT_TOS);
            this.put(KEY_BIND_TO_HOST, "");
            this.put(KEY_IPV6_ENABLED, false);
            this.put(KEY_TRANSPORT_PROTOCOL, DEFAULT_TRANSPORT_PROTOCOL);
            this.put(KEY_TCP_BUFFER_LENGTH, 2.0);
            this.put(KEY_TCP_BUFFER_LENGTH_UNIT, DEFAULT_TCP_BUFFER_LENGTH_UNIT);
            this.put(KEY_TCP_BUFFER_LENGTH_ENABLED, false);
            this.put(KEY_TCP_WINDOW_SIZE, 56.0);
            this.put(KEY_TCP_WINDOW_SIZE_UNIT, DEFAULT_TCP_WINDOW_SIZE_UNIT);
            this.put(KEY_TCP_WINDOW_SIZE_ENABLED, false);
            this.put(KEY_TCP_MSS, 1.0);
            this.put(KEY_TCP_MSS_UNIT, DEFAULT_TCP_MSS_UNIT);
            this.put(KEY_TCP_MSS_ENABLED, false);
            this.put(KEY_TCP_NO_DELAY_ENABLED, false);
            this.put(KEY_UDP_BANDWIDTH, 1.0);
            this.put(KEY_UDP_BANDWIDTH_UNIT, DEFAULT_UDP_BANDWIDTH_UNIT);
            this.put(KEY_UDP_BUFFER_SIZE, 41.0);
            this.put(KEY_UDP_BUFFER_SIZE_UNIT, DEFAULT_UDP_BUFFER_SIZE_UNIT);
            this.put(KEY_UDP_BUFFER_SIZE_ENABLED, false);
            this.put(KEY_UDP_PACKET_SIZE, 1500.0);
            this.put(KEY_UDP_PACKET_SIZE_UNIT, DEFAULT_UDP_PACKET_SIZE_UNIT);
            this.put(KEY_UDP_PACKET_SIZE_ENABLED, false);
            this.put(KEY_COMPATIBILITY_MODE_ENABLED, false);
            this.put(KEY_TRANSMIT, 10);
            this.put(KEY_TRANSMIT_UNIT, DEFAULT_TRANSMIT_UNIT);
            this.put(KEY_OUTPUT_FORMAT, DEFAULT_OUTPUT_FORMAT);
            this.put(KEY_REPORT_INTERVAL, 1);
            this.put(KEY_TEST_MODE_DUAL_ENABLED, false);
            this.put(KEY_TEST_MODE_TRADE_ENABLED, false);
            this.put(KEY_TEST_MODE_PORT, 5001);
            this.put(KEY_PRINT_MSS_ENABLED, false);
        }
    }

    public IPerfProperties(File file) throws Exception {
        if (!file.exists()) {
            throw new Exception("The file '" + file.getAbsolutePath() + "' does not exist");
        }
        this.properties.load(new FileInputStream(file));
    }

    public void saveAs(File file) throws Exception {
        file.delete();
        this.properties.store(new FileOutputStream(file), "");
    }

    public void put(String string, int n) {
        this.properties.put(string, "" + n);
    }

    public int getInteger(String string, int n) {
        try {
            String string2 = (String)this.properties.get(string);
            return Integer.parseInt(string2);
        }
        catch (Exception exception) {
            return n;
        }
    }

    public void put(String string, double d) {
        this.properties.put(string, "" + d);
    }

    public double getDouble(String string, double d) {
        try {
            String string2 = (String)this.properties.get(string);
            return Double.parseDouble(string2);
        }
        catch (Exception exception) {
            return d;
        }
    }

    public void put(String string, boolean bl) {
        this.properties.put(string, "" + bl);
    }

    public boolean getBoolean(String string, boolean bl) {
        try {
            String string2 = (String)this.properties.get(string);
            return Boolean.parseBoolean(string2);
        }
        catch (Exception exception) {
            return bl;
        }
    }

    public void put(String string, IperfUnit iperfUnit) {
        this.properties.put(string, iperfUnit.name());
    }

    public IperfUnit getUnit(String string, IperfUnit iperfUnit) {
        try {
            String string2 = (String)this.properties.get(string);
            return IperfUnit.valueOf(string2.toUpperCase());
        }
        catch (Exception exception) {
            return iperfUnit;
        }
    }

    public void put(String string, IperfSpeedUnit iperfSpeedUnit) {
        this.properties.put(string, iperfSpeedUnit.name());
    }

    public IperfSpeedUnit getSpeedUnit(String string, IperfSpeedUnit iperfSpeedUnit) {
        try {
            String string2 = (String)this.properties.get(string);
            return IperfSpeedUnit.valueOf(string2.toUpperCase());
        }
        catch (Exception exception) {
            return iperfSpeedUnit;
        }
    }

    public void put(String string, TosOption tosOption) {
        this.properties.put(string, tosOption.name());
    }

    public TosOption getTosOption(String string, TosOption tosOption) {
        try {
            String string2 = (String)this.properties.get(string);
            return TosOption.valueOf(string2.toUpperCase());
        }
        catch (Exception exception) {
            return tosOption;
        }
    }

    public void put(String string, String string2) {
        this.properties.put(string, string2);
    }

    public String getString(String string, String string2) {
        String string3 = (String)this.properties.get(string);
        if (string3 == null || string3.trim().equals("")) {
            return string2;
        }
        return string3;
    }
}

