#ifndef GNU_PACKED
#define GNU_PACKED  __attribute__ ((packed))
#endif /* GNU_PACKED */

#define STATION_JOIN 1
#define STATION_LEAVE 0

struct GNU_PACKED ssid_2_vid_mapping {
	char ssid[32];
	unsigned short vlan_id;
};

struct GNU_PACKED ts_policy {
	unsigned char num;
	struct ssid_2_vid_mapping ssid_2_vid[0];
};

struct GNU_PACKED ts_default_8021q {
	unsigned short primary_vid;
	unsigned char default_pcp;
};

struct GNU_PACKED transparent_vids {
	unsigned char num;
	unsigned short vids[0];
};

struct GNU_PACKED client_vid {
	unsigned char client_mac[ETH_ALEN];
	unsigned short vid;
	unsigned char status;
};

void ts_init(void);
void ts_deinit(void);
unsigned char handle_ts_default_8021q(unsigned short primary_vid, unsigned char default_pcp);
unsigned char handle_ts_policy(struct ts_policy *policy);
unsigned int ts_tx_process(struct sk_buff *skb, unsigned char wan_tag);
unsigned int ts_rx_process(struct sk_buff *skb, unsigned char wan_tag);
unsigned int ts_local_in_process(struct sk_buff *skb);
unsigned int ts_local_out_process(struct sk_buff *skb, unsigned char out_type);
unsigned int ts_ip_pre_routing_process(struct sk_buff *skb);
unsigned char handle_transparent_vlan(struct transparent_vids *tvids);
unsigned char handle_client_vid(struct client_vid *client);
unsigned char is_transparent_vlan_on(void);
unsigned int is_transparent_vlan(unsigned short vid);

void dump_ts_info(void);

