#ifndef __MT7915_H__
#define __MT7915_H__

struct _RTMP_ADAPTER;
struct _RTMP_CHIP_DBG;

#define MT7915_BIN_FILE_NAME_E1 "WIFI_RAM_CODE_MT7915.bin"
#define MT7915_BIN_FILE_NAME_E2 "WIFI_RAM_CODE_MT7915_E2.bin"
#define MT7915_WA_BIN_FILE_NAME "7915_WACPU_RAM_CODE_release.bin"
#define MT7915_ROM_PATCH_BIN_FILE_NAME_E1 "mt7915_patch_e1_hdr.bin"
#define MT7915_ROM_PATCH_BIN_FILE_NAME_E2 "mt7915_patch_e2_hdr.bin"

#define MT7915_ROM_PATCH_START_ADDRESS	0x00200000

#define MT7915_MT_WTBL_SIZE         288

#define MAX_NUM_OF_MT7915_STA       256

#define WTBL_MASK_UPDATE_MAX_RETRY	64000

#define EEPROM_ANTENNA_CFG_OFFSET           0x190
#define TX_MASK                             BITS(0, 2)
#define TX_OFFSET                           0
#define RX_MASK                             BITS(3, 5)
#define RX_OFFSET                           3

/* rxv dara word */
#define E1_RXV_PACKET_HEADER_DW_NUM    2
#define E1_RXV_ENTRY_HEADER_DW_NUM    2
#define E1_CMN_RXV1_DW_NUM    18
#define E1_CMN_RXV2_DW_NUM    20
#define E1_USR_RXV1_DW_NUM    2
#define E1_USR_RXV2_DW_NUM    4
#define E2_RXV_PACKET_HEADER_DW_NUM    2
#define E2_RXV_ENTRY_HEADER_DW_NUM    2
#define E2_CMN_RXV1_DW_NUM    18
#define E2_CMN_RXV2_DW_NUM    26
#define E2_USR_RXV1_DW_NUM    2
#define E2_USR_RXV2_DW_NUM    4

/* rxv double data word low/high cycle */
#define RXV_DDW0_L     0
#define RXV_DDW0_H     1
#define RXV_DDW1_L     2
#define RXV_DDW1_H     3
#define RXV_DDW2_L     4
#define RXV_DDW2_H     5
#define RXV_DDW3_L     6
#define RXV_DDW3_H     7
#define RXV_DDW4_L     8
#define RXV_DDW4_H     9
#define RXV_DDW5_L     10
#define RXV_DDW5_H     11
#define RXV_DDW6_L     12
#define RXV_DDW6_H     13
#define RXV_DDW7_L     14
#define RXV_DDW7_H     15
#define RXV_DDW8_L     16
#define RXV_DDW8_H     17
#define RXV_DDW9_L     18
#define RXV_DDW9_H     19
#define RXV_DDW10_L    20
#define RXV_DDW10_H    21

#define MUM_VHT_4MU_GRP_NUM 5

#define TSSI_CAL_2G_SIZE  (9 * 4)
#define TSSI_CAL_5G_SIZE  (48 * 4)
#define DNL_CAL_SIZE      (158 * 4)

#define TSSI_CAL_2G_EEPROM_OFST  0x308
#define TSSI_CAL_5G_EEPROM_OFST  0x380
#define TX_DNL_CAL_EEPROM_OFST   0xAFC

/* RF LOCKDOWN */
#define COUNTRY_CODE_BYTE0_EEPROME_OFFSET   0x5C
#define COUNTRY_CODE_BYTE1_EEPROME_OFFSET   0x5D
#define COUNTRY_REGION_2G_EEPROME_OFFSET    0x5E
#define COUNTRY_REGION_5G_EEPROME_OFFSET    0x5F
#define COUNTRY_REGION_VALIDATION_MASK      BIT(7)
#define COUNTRY_REGION_VALIDATION_OFFSET    7
#define COUNTRY_REGION_CONTENT_MASK         BITS(0, 6)
#define RF_LOCKDOWN_EEPROME_BLOCK_OFFSET    0x50
#define RF_LOCKDOWN_EEPROME_COLUMN_OFFSET   0xB
#define RF_LOCKDOWN_EEPROME_OFFSET          0x5B
#define RF_LOCKDOWN_EEPROME_MASK            BIT(7)
#define RF_LOCKDOWN_EEPROME_SHIFT           7
#define RF_LOCKDOWN_EEPROME_SKU_TBL_OFFSET  0x5B
#define RF_LOCKDOWN_EEPROME_SKU_TBL_MASK    BITS(0, 6)
#define RF_LOCKDOWN_EEPROME_SKU_TBL_SHIFT   0
#define RF_VALIDATION_NUMBER                10

static const UINT16 wtbl_e1_risky_wcid[] = {
	0, 1, 2, 3,
	32, 33, 34, 35,
	64, 65, 66, 67,
	96, 97, 98, 99,
	128, 129, 130, 131,
	160, 161, 162, 163,
	192, 193, 194, 195,
	224, 225, 226, 227 /* total 32 wtbl entries */
};

typedef enum _POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY {
	SINGLE_SKU_TABLE_CCK = 0,
	SINGLE_SKU_TABLE_OFDM,
	SINGLE_SKU_TABLE_HT20,
	SINGLE_SKU_TABLE_HT40,
	SINGLE_SKU_TABLE_VHT20,
	SINGLE_SKU_TABLE_VHT40,
	SINGLE_SKU_TABLE_VHT80,
	SINGLE_SKU_TABLE_VHT160,
	SINGLE_SKU_TABLE_RU26,
	SINGLE_SKU_TABLE_RU52,
	SINGLE_SKU_TABLE_RU106,
	SINGLE_SKU_TABLE_RU242,
	SINGLE_SKU_TABLE_RU484,
	SINGLE_SKU_TABLE_RU996,
	SINGLE_SKU_TABLE_RU996X2,
	SINGLE_SKU_TABLE_NUM
} POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY, *P_POWER_LIMIT_TABLE_TYPE_SKU_CATEGORY;

typedef enum _POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY {
	BACKOFF_TABLE_BF_OFF_CCK = 0,
	BACKOFF_TABLE_BF_OFF_OFDM,
	BACKOFF_TABLE_BF_ON_OFDM,
	BACKOFF_TABLE_BF_OFF_HT20,
	BACKOFF_TABLE_BF_ON_HT20,
	BACKOFF_TABLE_BF_OFF_HT40,
	BACKOFF_TABLE_BF_ON_HT40,
	BACKOFF_TABLE_BF_OFF_VHT20,
	BACKOFF_TABLE_BF_ON_VHT20,
	BACKOFF_TABLE_BF_OFF_VHT40,
	BACKOFF_TABLE_BF_ON_VHT40,
	BACKOFF_TABLE_BF_OFF_VHT80,
	BACKOFF_TABLE_BF_ON_VHT80,
	BACKOFF_TABLE_BF_OFF_VHT160,
	BACKOFF_TABLE_BF_ON_VHT160,
	BACKOFF_TABLE_BF_OFF_RU26,
	BACKOFF_TABLE_BF_ON_RU26,
	BACKOFF_TABLE_BF_OFF_RU52,
	BACKOFF_TABLE_BF_ON_RU52,
	BACKOFF_TABLE_BF_OFF_RU106,
	BACKOFF_TABLE_BF_ON_RU106,
	BACKOFF_TABLE_NUM
} POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY, *P_POWER_LIMIT_TABLE_TYPE_BACKOFF_CATEGORY;

extern const CHAR cSkuParseTypeName[SINGLE_SKU_TYPE_PARSE_NUM_V1][8];
extern const CHAR cBackoffParseTypeName[BACKOFF_TYPE_PARSE_NUM_V1][14];

extern const UINT8 SINGLE_SKU_PARSE_TABLE_LENGTH[SINGLE_SKU_TYPE_PARSE_NUM_V1];

extern const UINT8 BACKOFF_TABLE_BF_LENGTH[BACKOFF_TYPE_PARSE_NUM_V1];
extern const UINT8 BACKOFF_FILL_TABLE_BF_LENGTH[BACKOFF_PARAM_NUM_V1];

typedef enum _ENUM_TXPOWER_TYPE_CCK_T {
	MODULATION_SYSTEM_CCK_1M = 0,
	MODULATION_SYSTEM_CCK_2M,
	MODULATION_SYSTEM_CCK_5M,
	MODULATION_SYSTEM_CCK_11M,
	MODULATION_SYSTEM_CCK_NUM
} ENUM_TXPOWER_TYPE_CCK_T, *P_ENUM_TXPOWER_TYPE_CCK_T;

typedef enum _ENUM_TXPOWER_TYPE_OFDM_T {
	MODULATION_SYSTEM_OFDM_6M = 0,
	MODULATION_SYSTEM_OFDM_9M,
	MODULATION_SYSTEM_OFDM_12M,
	MODULATION_SYSTEM_OFDM_18M,
	MODULATION_SYSTEM_OFDM_24M,
	MODULATION_SYSTEM_OFDM_36M,
	MODULATION_SYSTEM_OFDM_48M,
	MODULATION_SYSTEM_OFDM_54M,
	MODULATION_SYSTEM_OFDM_NUM
} ENUM_TXPOWER_TYPE_OFDM_T, *P_ENUM_TXPOWER_TYPE_OFDM_T;

typedef enum _ENUM_TXPOWER_TYPE_HT20_T {
	MODULATION_SYSTEM_HT20_MCS0 = 0,
	MODULATION_SYSTEM_HT20_MCS1,
	MODULATION_SYSTEM_HT20_MCS2,
	MODULATION_SYSTEM_HT20_MCS3,
	MODULATION_SYSTEM_HT20_MCS4,
	MODULATION_SYSTEM_HT20_MCS5,
	MODULATION_SYSTEM_HT20_MCS6,
	MODULATION_SYSTEM_HT20_MCS7,
	MODULATION_SYSTEM_HT20_NUM
} ENUM_TXPOWER_TYPE_HT20_T, *P_ENUM_TXPOWER_TYPE_HT20_T;

typedef enum _ENUM_TXPOWER_TYPE_HT40_T {
	MODULATION_SYSTEM_HT40_MCS0 = 0,
	MODULATION_SYSTEM_HT40_MCS1,
	MODULATION_SYSTEM_HT40_MCS2,
	MODULATION_SYSTEM_HT40_MCS3,
	MODULATION_SYSTEM_HT40_MCS4,
	MODULATION_SYSTEM_HT40_MCS5,
	MODULATION_SYSTEM_HT40_MCS6,
	MODULATION_SYSTEM_HT40_MCS7,
	MODULATION_SYSTEM_HT40_MCS32,
	MODULATION_SYSTEM_HT40_NUM
} ENUM_TXPOWER_TYPE_HT40_T, *P_ENUM_TXPOWER_TYPE_HT40_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT20_T {
	MODULATION_SYSTEM_VHT20_MCS0 = 0,
	MODULATION_SYSTEM_VHT20_MCS1,
	MODULATION_SYSTEM_VHT20_MCS2,
	MODULATION_SYSTEM_VHT20_MCS3,
	MODULATION_SYSTEM_VHT20_MCS4,
	MODULATION_SYSTEM_VHT20_MCS5,
	MODULATION_SYSTEM_VHT20_MCS6,
	MODULATION_SYSTEM_VHT20_MCS7,
	MODULATION_SYSTEM_VHT20_MCS8,
	MODULATION_SYSTEM_VHT20_MCS9,
	MODULATION_SYSTEM_VHT20_MCS10,
	MODULATION_SYSTEM_VHT20_MCS11,
	MODULATION_SYSTEM_VHT20_NUM
} ENUM_TXPOWER_TYPE_VHT20_T, *P_ENUM_TXPOWER_TYPE_VHT20_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT40_T {
	MODULATION_SYSTEM_VHT40_MCS0 = 0,
	MODULATION_SYSTEM_VHT40_MCS1,
	MODULATION_SYSTEM_VHT40_MCS2,
	MODULATION_SYSTEM_VHT40_MCS3,
	MODULATION_SYSTEM_VHT40_MCS4,
	MODULATION_SYSTEM_VHT40_MCS5,
	MODULATION_SYSTEM_VHT40_MCS6,
	MODULATION_SYSTEM_VHT40_MCS7,
	MODULATION_SYSTEM_VHT40_MCS8,
	MODULATION_SYSTEM_VHT40_MCS9,
	MODULATION_SYSTEM_VHT40_MCS10,
	MODULATION_SYSTEM_VHT40_MCS11,
	MODULATION_SYSTEM_VHT40_NUM
} ENUM_TXPOWER_TYPE_VHT40_T, *P_ENUM_TXPOWER_TYPE_VHT40_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT80_T {
	MODULATION_SYSTEM_VHT80_MCS0 = 0,
	MODULATION_SYSTEM_VHT80_MCS1,
	MODULATION_SYSTEM_VHT80_MCS2,
	MODULATION_SYSTEM_VHT80_MCS3,
	MODULATION_SYSTEM_VHT80_MCS4,
	MODULATION_SYSTEM_VHT80_MCS5,
	MODULATION_SYSTEM_VHT80_MCS6,
	MODULATION_SYSTEM_VHT80_MCS7,
	MODULATION_SYSTEM_VHT80_MCS8,
	MODULATION_SYSTEM_VHT80_MCS9,
	MODULATION_SYSTEM_VHT80_MCS10,
	MODULATION_SYSTEM_VHT80_MCS11,
	MODULATION_SYSTEM_VHT80_NUM
} ENUM_TXPOWER_TYPE_VHT80_T, *P_ENUM_TXPOWER_TYPE_VHT80_T;

typedef enum _ENUM_TXPOWER_TYPE_VHT160_T {
	MODULATION_SYSTEM_VHT160_MCS0 = 0,
	MODULATION_SYSTEM_VHT160_MCS1,
	MODULATION_SYSTEM_VHT160_MCS2,
	MODULATION_SYSTEM_VHT160_MCS3,
	MODULATION_SYSTEM_VHT160_MCS4,
	MODULATION_SYSTEM_VHT160_MCS5,
	MODULATION_SYSTEM_VHT160_MCS6,
	MODULATION_SYSTEM_VHT160_MCS7,
	MODULATION_SYSTEM_VHT160_MCS8,
	MODULATION_SYSTEM_VHT160_MCS9,
	MODULATION_SYSTEM_VHT160_MCS10,
	MODULATION_SYSTEM_VHT160_MCS11,
	MODULATION_SYSTEM_VHT160_NUM
} ENUM_TXPOWER_TYPE_VHT160_T, *P_ENUM_TXPOWER_TYPE_VHT160_T;

typedef enum _ENUM_TXPOWER_TYPE_HE26_T {
	MODULATION_SYSTEM_HE26_MCS0 = 0,
	MODULATION_SYSTEM_HE26_MCS1,
	MODULATION_SYSTEM_HE26_MCS2,
	MODULATION_SYSTEM_HE26_MCS3,
	MODULATION_SYSTEM_HE26_MCS4,
	MODULATION_SYSTEM_HE26_MCS5,
	MODULATION_SYSTEM_HE26_MCS6,
	MODULATION_SYSTEM_HE26_MCS7,
	MODULATION_SYSTEM_HE26_MCS8,
	MODULATION_SYSTEM_HE26_MCS9,
	MODULATION_SYSTEM_HE26_MCS10,
	MODULATION_SYSTEM_HE26_MCS11,
	MODULATION_SYSTEM_HE26_NUM
} ENUM_TXPOWER_TYPE_HE26_T, *P_ENUM_TXPOWER_TYPE_HE26_T;

typedef enum _ENUM_TXPOWER_TYPE_HE52_T {
	MODULATION_SYSTEM_HE52_MCS0 = 0,
	MODULATION_SYSTEM_HE52_MCS1,
	MODULATION_SYSTEM_HE52_MCS2,
	MODULATION_SYSTEM_HE52_MCS3,
	MODULATION_SYSTEM_HE52_MCS4,
	MODULATION_SYSTEM_HE52_MCS5,
	MODULATION_SYSTEM_HE52_MCS6,
	MODULATION_SYSTEM_HE52_MCS7,
	MODULATION_SYSTEM_HE52_MCS8,
	MODULATION_SYSTEM_HE52_MCS9,
	MODULATION_SYSTEM_HE52_MCS10,
	MODULATION_SYSTEM_HE52_MCS11,
	MODULATION_SYSTEM_HE52_NUM
} ENUM_TXPOWER_TYPE_HE52_T, *P_ENUM_TXPOWER_TYPE_HE52_T;

typedef enum _ENUM_TXPOWER_TYPE_HE106_T {
	MODULATION_SYSTEM_HE106_MCS0 = 0,
	MODULATION_SYSTEM_HE106_MCS1,
	MODULATION_SYSTEM_HE106_MCS2,
	MODULATION_SYSTEM_HE106_MCS3,
	MODULATION_SYSTEM_HE106_MCS4,
	MODULATION_SYSTEM_HE106_MCS5,
	MODULATION_SYSTEM_HE106_MCS6,
	MODULATION_SYSTEM_HE106_MCS7,
	MODULATION_SYSTEM_HE106_MCS8,
	MODULATION_SYSTEM_HE106_MCS9,
	MODULATION_SYSTEM_HE106_MCS10,
	MODULATION_SYSTEM_HE106_MCS11,
	MODULATION_SYSTEM_HE106_NUM
} ENUM_TXPOWER_TYPE_HE106_T, *P_ENUM_TXPOWER_TYPE_HE106_T;

typedef enum _ENUM_TXPOWER_TYPE_HE242_T {
	MODULATION_SYSTEM_HE242_MCS0 = 0,
	MODULATION_SYSTEM_HE242_MCS1,
	MODULATION_SYSTEM_HE242_MCS2,
	MODULATION_SYSTEM_HE242_MCS3,
	MODULATION_SYSTEM_HE242_MCS4,
	MODULATION_SYSTEM_HE242_MCS5,
	MODULATION_SYSTEM_HE242_MCS6,
	MODULATION_SYSTEM_HE242_MCS7,
	MODULATION_SYSTEM_HE242_MCS8,
	MODULATION_SYSTEM_HE242_MCS9,
	MODULATION_SYSTEM_HE242_MCS10,
	MODULATION_SYSTEM_HE242_MCS11,
	MODULATION_SYSTEM_HE242_NUM
} ENUM_TXPOWER_TYPE_HE242_T, *P_ENUM_TXPOWER_TYPE_HE242_T;

typedef enum _ENUM_TXPOWER_TYPE_HE484_T {
	MODULATION_SYSTEM_HE484_MCS0 = 0,
	MODULATION_SYSTEM_HE484_MCS1,
	MODULATION_SYSTEM_HE484_MCS2,
	MODULATION_SYSTEM_HE484_MCS3,
	MODULATION_SYSTEM_HE484_MCS4,
	MODULATION_SYSTEM_HE484_MCS5,
	MODULATION_SYSTEM_HE484_MCS6,
	MODULATION_SYSTEM_HE484_MCS7,
	MODULATION_SYSTEM_HE484_MCS8,
	MODULATION_SYSTEM_HE484_MCS9,
	MODULATION_SYSTEM_HE484_MCS10,
	MODULATION_SYSTEM_HE484_MCS11,
	MODULATION_SYSTEM_HE484_NUM
} ENUM_TXPOWER_TYPE_HE484_T, *P_ENUM_TXPOWER_TYPE_HE484_T;

typedef enum _ENUM_TXPOWER_TYPE_HE996_T {
	MODULATION_SYSTEM_HE996_MCS0 = 0,
	MODULATION_SYSTEM_HE996_MCS1,
	MODULATION_SYSTEM_HE996_MCS2,
	MODULATION_SYSTEM_HE996_MCS3,
	MODULATION_SYSTEM_HE996_MCS4,
	MODULATION_SYSTEM_HE996_MCS5,
	MODULATION_SYSTEM_HE996_MCS6,
	MODULATION_SYSTEM_HE996_MCS7,
	MODULATION_SYSTEM_HE996_MCS8,
	MODULATION_SYSTEM_HE996_MCS9,
	MODULATION_SYSTEM_HE996_MCS10,
	MODULATION_SYSTEM_HE996_MCS11,
	MODULATION_SYSTEM_HE996_NUM
} ENUM_TXPOWER_TYPE_HE996_T, *P_ENUM_TXPOWER_TYPE_HE996_T;

typedef enum _ENUM_TXPOWER_TYPE_HE996X2_T {
	MODULATION_SYSTEM_HE996X2_MCS0 = 0,
	MODULATION_SYSTEM_HE996X2_MCS1,
	MODULATION_SYSTEM_HE996X2_MCS2,
	MODULATION_SYSTEM_HE996X2_MCS3,
	MODULATION_SYSTEM_HE996X2_MCS4,
	MODULATION_SYSTEM_HE996X2_MCS5,
	MODULATION_SYSTEM_HE996X2_MCS6,
	MODULATION_SYSTEM_HE996X2_MCS7,
	MODULATION_SYSTEM_HE996X2_MCS8,
	MODULATION_SYSTEM_HE996X2_MCS9,
	MODULATION_SYSTEM_HE996X2_MCS10,
	MODULATION_SYSTEM_HE996X2_MCS11,
	MODULATION_SYSTEM_HE996X2_NUM
} ENUM_TXPOWER_TYPE_HE996X2_T, *P_ENUM_TXPOWER_TYPE_HE996X2_T;

typedef struct _cos_msg_trace_t {
	UINT32 dest_id;
	UINT8 msg_id;
	UINT32 pcount;
	UINT32 qread;
	UINT32 ts_enq;
	UINT32 ts_deq;
	UINT32 ts_finshq;
} cos_msg_trace_t;

typedef void (*cos_main_func_ptr)(void);
typedef void (*cos_init_func_ptr)(void);

typedef struct _COS_MSGQID {
	UINT8 unused;
} COS_MSGQID, P_COS_MSGQID;

typedef struct {
	void                *tc_stack_start;
	void                *tc_stack_end;
	void                *tc_stack_pointer;
	UINT32           tc_stack_size;
	UINT32           tc_schedule_count;
	UINT8            tc_status;
	UINT8            tc_priority;
	UINT8            tc_weight;
	UINT8       RSVD[28];
	cos_main_func_ptr    tc_entry_func;
	UINT32           tc_exe_start;
	UINT32           tc_exe_time;
	UINT32           tc_exe_peak;
	UINT32           tc_pcount;
} cos_task_type, *cos_internal_taskid;

typedef struct {
	UCHAR                 *task_name_ptr;
	UCHAR                 *task_qname_ptr;
	UINT32           task_priority;
	UINT16           task_stack_size;
	UINT8            task_ext_qsize;
	UINT32           task_id;
	P_COS_MSGQID           task_ext_qid;
	cos_main_func_ptr    task_main_func;
	cos_init_func_ptr    task_init_func;
} task_info_struct;

typedef struct {
	UINT32           finish_cnt;
	UINT32           exe_time;
	UINT32           exe_peak;
} cos_msg_type, *cos_internal_msgid;

typedef struct {
	UINT32    dest_id;
	UINT32    msg_id;
	UINT32    msg_sn;
	UINT32    ts_gpt2;
	UINT32    ts_gpt4;
	UINT32    *LP;
	CHAR        name[12];
} cos_program_trace_t, *p_cos_program_trace_t;

/** Tx Power Rate Column Offset */
#define TXPOWER_RATE_CCK_OFFSET     (0)
#define TXPOWER_RATE_OFDM_OFFSET    (TXPOWER_RATE_CCK_OFFSET  + MODULATION_SYSTEM_CCK_NUM)
#define TXPOWER_RATE_HT20_OFFSET    (TXPOWER_RATE_OFDM_OFFSET + MODULATION_SYSTEM_OFDM_NUM)
#define TXPOWER_RATE_HT40_OFFSET    (TXPOWER_RATE_HT20_OFFSET + MODULATION_SYSTEM_HT20_NUM)
#define TXPOWER_RATE_VHT20_OFFSET   (TXPOWER_RATE_HT40_OFFSET + MODULATION_SYSTEM_HT40_NUM)
#define TXPOWER_RATE_VHT40_OFFSET   (TXPOWER_RATE_VHT20_OFFSET + MODULATION_SYSTEM_VHT20_NUM)
#define TXPOWER_RATE_VHT80_OFFSET   (TXPOWER_RATE_VHT40_OFFSET + MODULATION_SYSTEM_VHT40_NUM)
#define TXPOWER_RATE_VHT160_OFFSET  (TXPOWER_RATE_VHT80_OFFSET + MODULATION_SYSTEM_VHT80_NUM)
#define TXPOWER_RATE_LEG_RATE_NUM   (TXPOWER_RATE_VHT160_OFFSET + MODULATION_SYSTEM_VHT160_NUM)
#define TXPOWER_RATE_HE26_OFFSET    (TXPOWER_RATE_LEG_RATE_NUM)
#define TXPOWER_RATE_HE52_OFFSET    (TXPOWER_RATE_HE26_OFFSET + MODULATION_SYSTEM_HE26_NUM)
#define TXPOWER_RATE_HE106_OFFSET   (TXPOWER_RATE_HE52_OFFSET + MODULATION_SYSTEM_HE52_NUM)
#define TXPOWER_RATE_HE242_OFFSET   (TXPOWER_RATE_HE106_OFFSET + MODULATION_SYSTEM_HE106_NUM)
#define TXPOWER_RATE_HE484_OFFSET   (TXPOWER_RATE_HE242_OFFSET + MODULATION_SYSTEM_HE242_NUM)
#define TXPOWER_RATE_HE996_OFFSET   (TXPOWER_RATE_HE484_OFFSET + MODULATION_SYSTEM_HE484_NUM)
#define TXPOWER_RATE_HE996X2_OFFSET (TXPOWER_RATE_HE996_OFFSET + MODULATION_SYSTEM_HE996_NUM)
#define TXPOWER_RATE_NUM            (TXPOWER_RATE_HE996X2_OFFSET + MODULATION_SYSTEM_HE996X2_NUM)

/*
 * Used for DNL + TSSI Calibration happen in MP-Line state
 * 3 Channel for G-band L/M/H channel
 * 16 Channel for A-band L/H channel
 */
extern UINT16 MT7915_DNL_CAL_GBAND_BW20_FREQ[];
extern UINT16 MT7915_DNL_CAL_ABAND_BW20_FREQ[];
extern UINT16 MT7915_DNL_CAL_BW20_FREQ[];

extern UINT16 MT7915_DNL_CAL_GBAND_BW20_CH[];
extern UINT16 MT7915_DNL_CAL_ABAND_BW20_CH[];
extern UINT16 MT7915_DNL_CAL_BW20_CH[];

extern UINT16 MT7915_DNL_CAL_GBAND_BW20_SIZE;
extern UINT16 MT7915_DNL_CAL_ABAND_BW20_SIZE;
extern UINT16 MT7915_DNL_CAL_BW20_FREQ_SIZE;

extern UINT16 MT7915_DNL_CAL_GBAND_BW20_CH_SIZE;
extern UINT16 MT7915_DNL_CAL_ABAND_BW20_CH_SIZE;
extern UINT16 MT7915_DNL_CAL_B20_CH_SIZE;

#ifdef CONNAC_EFUSE_FORMAT_SUPPORT
typedef struct _EFUSE_INFO_T {
	/* MT7915 as example */
	UINT8 bytes_0x0_0x6F[0x70]; /* 0x00 ~ 0x6F : other purpose */
	/* 0x70 */
	EFUSE_INFO_MODULE_TX_POWER_T rTxPower; /* 59 bytes */
	UINT8 bytes_0xAB_0xAF[0x5]; /* 0x100 ~ 0x1AF : padding */
	/* 0xB0 */
	EFUSE_INFO_MODULE_2G4_COMMON_T r2G4Cmm; /* 48 bytes */
	/* 0xE0 */
	EFUSE_INFO_MODULE_2G4_WIFI_PATH_T ar2G4WFPath[MAX_ANTENNA_NUM]; /* 16*2=32 bytes */
	UINT8 bytes_0x100_0x1AF[0xB0]; /* 0x100 ~ 0x1AF : other purpose */
	/* 0x1B0 */
	EFUSE_INFO_MODULE_SYSTEM_T rSys; /* 16 bytes */
	/* 0x1C0 */
	EFUSE_INFO_MODULE_DELAY_COMP_T rDelayComp; /* 34 bytes */
	UINT8 bytes_0x1E2_0x1EF[0xE]; /* 0x1E2 ~ 0x1EF: padding */
	/* 0x1F0 */
	EFUSE_INFO_MODULE_5G_COMMON_T r5GCmm; /* 80 bytes */
	/* 0x240 */
	EFUSE_INFO_MODULE_5G_WIFI_PATH_T ar5GWFPath[MAX_ANTENNA_NUM]; /* 112*2=224 bytes */
	/* 0x320 */
	EFUSE_INFO_MODULE_IBF_CAL_T rIBfCal; /* 12*9=108 bytes */
	UINT8 bytes_0x38C_0x3FF[0x74]; /* 0x38C ~ 0x3FF: other purpose */
	UINT8 bytes_ADie_0x000_0x17F[0x180]; /* A Die 0x000 ~ 0x17F */
} EFUSE_INFO_T, *P_EFUSE_INFO_T;
#endif /*#ifdef CONNAC_EFUSE_FORMAT_SUPPORT*/

enum ENUM_TXMODE {
	TXMODE_LEGACY_CCK = 0x0,
	TXMODE_LEGACY_OFDMA = 0x1,
	TXMODE_HT_MIXED = 0x2,
	TXMODE_HT_GREEN_FIELD = 0x3,
	TXMODE_VHT = 0x4,
	TXMODE_HE_SU = 0x8,
	TXMODE_HE_EXT_SU = 0x9,
	TXMODE_HE_TRIG = 0xA,
	TXMODE_HE_MU = 0xB
};


void mt7915_init(struct _RTMP_ADAPTER *pAd);
VOID mt7915_chip_dbg_init(struct _RTMP_CHIP_DBG *dbg_ops);
INT mt7915AsicArchOpsInit(struct _RTMP_ADAPTER *pAd);
VOID mt7916_hif_init(VOID *hif_ctrl);
VOID mt7915_hif_ctrl_chip_init(VOID *hif_chip);

#ifdef PRE_CAL_MT7915_SUPPORT

enum {
    GBAND = 0,
    ABAND = 1,
};


#ifdef RTMP_FLASH_SUPPORT
#define PRECAL_INDICATION_BYTE 0x62
enum PRECAL_INDICATION_BIT_OFFSET {
	GROUP_PRECAL_INDN_BIT = 0,
	DPD5G_PRECAL_INDN_BIT,
	DPD2G_PRECAL_INDN_BIT,
};

#define CAL_PRE_CAL_SIZE_OFFSET  3584	/* DW0 : 0xE00 ~ 0xE03 Used for save total pre-cal size
										*  DW1 : reserved
										*  DW2 : reserved
										*  DW3 : reserved
										*/
#define CAL_FLASH_OFFSET         3600  /* 0xE10 ~ 0x5780 Used for save Group calibration data */
#else
#define CAL_FLASH_OFFSET         0
#endif

/* Group Calibration item */
#define CAL_RESULT_SIZE          (4 * 1024)
#define CAL_RESULT_SIZE_5G       (40 * 1024)
#define CAL_RESULT_SIZE_6G       (5 * 1024)
#define CAL_RESULT_SIZE_ADCDCOC  (4 * 4)
#define PRE_CAL_TOTAL_SIZE       (CAL_RESULT_SIZE + CAL_RESULT_SIZE_5G + CAL_RESULT_SIZE_6G + CAL_RESULT_SIZE_ADCDCOC)

/* DPD & Flatness item */
#define DPD_FLATNESS_CAL_SIZE    (2 * 1024)
#define DPD_FLATNESS_5G_CHAN_NUM 24
#define DPD_FLATNESS_2G_CHAN_NUM 3
#define TOTAL_CHAN_FOR_DPD_CAL   (DPD_FLATNESS_5G_CHAN_NUM + DPD_FLATNESS_2G_CHAN_NUM)
#define DPD_CAL_5G_TOTAL_SIZE    (DPD_FLATNESS_CAL_SIZE * DPD_FLATNESS_5G_CHAN_NUM)
#define DPD_CAL_2G_TOTAL_SIZE    (DPD_FLATNESS_CAL_SIZE * DPD_FLATNESS_2G_CHAN_NUM)
#define DPD_CAL_TOTAL_SIZE       (DPD_FLATNESS_CAL_SIZE * TOTAL_CHAN_FOR_DPD_CAL)

/* Flash offset */
#define PRE_CAL_FLASH_OFFSET     (CAL_FLASH_OFFSET)
#define DPD_FLASH_OFFSET         (CAL_FLASH_OFFSET + PRE_CAL_TOTAL_SIZE)

/* Length limitation from Host to Firmware */
#define PRE_CAL_SET_MAX_CR_NUM   256
#define PRE_CAL_SET_MAX_LENGTH   (PRE_CAL_SET_MAX_CR_NUM * 4)

extern UINT16 MT7915_DPD_FLATNESS_ABAND_BW20_FREQ[];
extern UINT16 MT7915_DPD_FLATNESS_GBAND_BW20_FREQ[];
extern UINT16 MT7915_DPD_FLATNESS_BW20_FREQ[];
extern UINT16 MT7915_DPD_FLATNESS_ABAND_BW20_SIZE;
extern UINT16 MT7915_DPD_FLATNESS_GBAND_BW20_SIZE;
extern UINT16 MT7915_DPD_FLATNESS_BW20_FREQ_SIZE;

extern UINT16 MT7915_DPD_FLATNESS_ABAND_BW20_CH[];
extern UINT16 MT7915_DPD_FLATNESS_GBAND_BW20_CH[];
extern UINT16 MT7915_DPD_FLATNESS_BW20_CH[];
extern UINT16 MT7915_DPD_FLATNESS_ABAND_BW20_CH_SIZE;
extern UINT16 MT7915_DPD_FLATNESS_GBAND_BW20_CH_SIZE;
extern UINT16 MT7915_DPD_FLATNESS_B20_CH_SIZE;
#endif /*PRE_CAL_MT7915_SUPPORT*/

#endif /* __MT7915_H__ */

