#include    "rt_config.h"

#ifndef _KERNEL_RPS_ADJUST_H_
#define _KERNEL_RPS_ADJUST_H_
/* mcli kernel rps state */
#define MCLI_RPS_RESET_FLAG		(1 << 0)
#define	MCLI_RPS_APPLY_FLAG		(1 << 1)
#define MCLI_IXIA_STA_DETECT_FLAG	(1 << 2)

/* mcli iwpriv cmd */
#define MCLI_RPS_ADJUST_ENABLE	1
#define MCLI_FORCE_AGGLIMIT 	2
#define MCLI_SHOW_INFO 		3
#define MCLI_DEBUG_ON		4
#define MCLI_RX_RPS_ENABLE	5
#define MCLI_RX_RPS_CPUMAP	6
#define MCLI_FORCE_RPS_CFG	7
#define MCLI_FORCE_TX_PROCESS_CNT	8

#define DEFAULT_NET_DEV_TX_QLEN	1000

typedef enum {
	NORMAL_RPS_MODE,
	BAND0_DETECT_MODE,
	BAND1_DETECT_MODE,
	RESET_RPS_MODE,
	MIN_RPS_MODE,
	BAND0_DL_RPS_MODE,
	BAND0_UDP_DL_RPS_MODE,
	BAND0_UDP_DL_TXFREE_IRQ_MODE,
	BAND0_UL_RPS_MODE,
	BAND1_DL_RPS_MODE,
	BAND1_UDP_DL_RPS_MODE,
	BAND1_UDP_DL_RPS_TXFREE_IRQ_MODE,
	BAND1_UL_RPS_MODE,
	BAND1_UL_TXFREE_IRQ_MODE,
	BAND1_UDP_UL_RPS_TXFREE_IRQ_MODE,
	BAND1_UDP_UL_RPS_MODE,
	BAND1_DL_TXFREE_IRQ_MODE,
	BAND0_UL_RPS_TXFREE_IRQ_MODE,
	BAND0_UDP_UL_RPS_TXFREE_IRQ_MODE,
	BAND0_BAND1_BIDIR_MODE,
	MIN_1_PAIR_RPS_MODE,
	BAND0_1_PAIR_UL_MODE,
	BAND0_1_PAIR_UL_UDP_MODE,
	BAND1_1_PAIR_UL_MODE,
	BAND0_1_PAIR_DL_MODE,
	BAND0_1_PAIR_UDP_DL_TX_FREE_IRQ_MODE,
	BAND1_1_PAIR_DL_MODE,
	BAND1_1_PAIR_L_PKT_UL_MODE,
	BAND1_1_PAIR_L_PKT_DL_MODE,
	MAX_1_PAIR_RPS_MODE,
	MAX_PROC_RPS_MODE
} PROC_RPS_MODE;

typedef enum {
	ETH0_RPS_FILE,
	BAND0_RPS_FILE,
	BAND1_RPS_FILE,
	MAX_PROC_NET_RPS_FILE,
	TXFREE_IRQ_FILE = MAX_PROC_NET_RPS_FILE,
	BACKLOG_QUEUE_FILE,
	RCU_STALL_TIMEOUT_FILE,
	MAX_KERNEL_PROC_RPS_FILE,
	HNAT_HOOK_TOGGLE_FILE = MAX_KERNEL_PROC_RPS_FILE,
	HNAT_ALL_ENTRY_FILE,
	MAX_APPLY_PROC_RPS_FILE,
	MAX_PROC_RPS_FILE = MAX_APPLY_PROC_RPS_FILE,
	NEET_BH_APPLY_FILE = 31
} PROC_RPS_FILE;

typedef enum {
	LAN_NET_DEV,
	BAND0_NET_DEV,
	BAND1_NET_DEV,
	MAX_NET_DEV
} PROC_NET_DEV;

struct ixia_mode_ctl_type {
	BOOLEAN mode_entered;
	UINT32 rps_mask;
	UINT8 band;
	UINT16 sta_nums;
	UINT32 num_entry;
	UINT32 max_mgmt_que_num_backup;
	UINT32 max_data_que_num_backup;
	BOOLEAN tx_tasklet_sch;
	BOOLEAN rx_tasklet_sch;
	BOOLEAN kernel_rps_en;
};

#define APPLY_ETH0_RPS_FLAG				(1<<ETH0_RPS_FILE)
#define APPLY_BAND0_RPS_FLAG				(1<<BAND0_RPS_FILE)
#define APPLY_BAND1_RPS_FLAG				(1<<BAND1_RPS_FILE)
#define APPLY_IRQ_FLAG					(1<<TXFREE_IRQ_FILE)
#define APPLY_QLEN_FLAG					(1<<BACKLOG_QUEUE_FILE)
#define APPLY_RCU_TIMEOUT_FLAG				(1<<RCU_STALL_TIMEOUT_FILE)
#define APPLY_HOOK_TOGGLE_FLAG				(1<<HNAT_HOOK_TOGGLE_FILE)
#define APPLY_ALL_ENTRY_FLAG                            (1<<HNAT_ALL_ENTRY_FILE)
#define APPLY_RPS_RESET_FLAG				(1<<MAX_PROC_RPS_FILE)
#define APPLY_NEED_BH_APPLY_FLAG			(1<<NEET_BH_APPLY_FILE)

void dynamic_proc_rps_adjust(struct _RTMP_ADAPTER *pAd);
void detect_1_pair_peak(struct _RTMP_ADAPTER *pAd, struct _MAC_TABLE_ENTRY *pEntry, UCHAR BandIdx);
BOOLEAN apply_proc_rps_setting_bh(struct _RTMP_ADAPTER *pAd);
#endif /* _KERNEL_RPS_ADJUST_H_ */
