/*
 * cleopatre/application/p1905_managerd/inc/p1905_ap_autoconfig.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef P1905_AP_AUTOCONFIG_H
#define P1905_AP_AUTOCONFIG_H


typedef enum
{
    no_ap_autoconfig = 1,
    wait_4_send_ap_autoconfig_search,
    wait_4_recv_ap_autoconfig_resp,
    wait_4_send_m1,
    wait_4_recv_m2,
    wait_4_set_config,

} enrolle_config_stage;

typedef enum {
	no_renew_bss = 1,
	wait_4_dump_topo,
	wait_4_pop_node,
	wait_4_send_renew,
	wait_4_recv_m1,
	wait_4_recv_m2_ack,
	wait_4_apply_local,
}renew_bss_state;

typedef enum
{
	controller_search_idle = 0,
	bk_link_ready = 1,
	wait_4_send_controller_search,
	wait_4_recv_controller_search_rsp,
	controller_search_done,
	
} controller_search_stage;

typedef struct _ap_config_para
{
    unsigned char e_nonce[16];
    unsigned char r_nonce[16];
    unsigned char private_key[192];
    unsigned char public_key[192];
    unsigned char security_key[192];
    unsigned char peer_public_key[192];
    unsigned char enrolle_mac[6];

    unsigned char authKey[32];
    unsigned char keyWrapKey[16];
#ifdef MAP_R2
    unsigned short auth_type;
#endif
} ap_config_para;

typedef enum
{
    MAP_CONF_UNCONF,
	MAP_CONF_CONFED,
} radio_config_stage;

void ap_auto_config_renew_start(void *pctx);
void ap_controller_search_step(void *eloop_ctx, void *timeout_ctx);
void ap_autoconfig_enrolle_step(void *eloop_ctx, void *timeout_ctx);
void controller_renew_bss_step(void *eloop_ctx, void *timeout_ctx);
void agent_apply_new_config(void *eloop_ctx, void *timeout_ctx);


#endif /* P1905_AP_AUTOCONFIG_H */
