/*
 * cleopatre/application/p1905_managerd/inc/cmdu.h
 *
 * (C) Copyright 2013 MSsar Semiconductor, Inc.
 */
#ifndef CMDU_H
#define CMDU_H
#include <sys/queue.h>

#include "p1905_managerd.h"
#include "cmdu_message.h"
#include "cmdu_message_parse.h"
#include "cmdu_tlv_parse.h"
#include "cmdu_fragment.h"
#include "multi_ap.h"

/** Interfaces name */
#define LO_IFNAME    "lo"
#define ETH0_IFNAME  "eth0"
#define PLC0_IFNAME  "plc0"
#define WIFI0_IFNAME  "ra0"

#define ETH_P_1905	(0x893a)
#define ETH_P_LLDP  (0x88cc)

struct txq_list
{
	unsigned char ifname[IFNAMSIZ];
    unsigned char dmac[6];
    unsigned char smac[6];
    msgtype mtype;
    unsigned short mid;
	unsigned char need_update_mid;
    TAILQ_ENTRY(txq_list) cmdu_txq_entry;
};

int cmdu_init(struct p1905_managerd_ctx *ctx);
void cmdu_uninit(struct p1905_managerd_ctx *ctx);
int process_cmdu_txq(struct p1905_managerd_ctx *ctx,unsigned char *buffer);
void insert_cmdu_txq(unsigned char *dmac, unsigned char *smac,msgtype mtype,
	unsigned short mid, unsigned char* ifname, unsigned char band);
int cmdu_bridge_receive(struct p1905_managerd_ctx *ctx, int sock, unsigned char *buf,int len);
int cmdu_parse(struct p1905_managerd_ctx *ctx,unsigned char *buf,int len);
int concurrent_sock_init(struct p1905_managerd_ctx *ctx);
int sniffer_init(struct p1905_managerd_ctx *ctx);
int cmdu_virtual_if_receive(struct p1905_managerd_ctx *ctx, int sock, unsigned char *buf, int len);
void sniffer_uninit(struct p1905_managerd_ctx *ctx);
int cmdu_tx_fragment(struct p1905_managerd_ctx *ctx,
	unsigned char *buffer, unsigned short buflen, int if_index);
int concurrent_sock_send(struct p1905_managerd_ctx *ctx,
	char *buffer_send, int length);
#ifdef SUPPORT_CONTROL_SOCKET
int _1905_ctrl_sock_init(struct p1905_managerd_ctx *ctx);
void _1905_ctrl_interface_recv_and_parse(struct p1905_managerd_ctx *ctx,
		char *buf, int len);
void  _1905_ctrl_sock_deinit(struct p1905_managerd_ctx *ctx);
#endif
#ifdef SUPPORT_CMDU_RELIABLE
void cmdu_reliable_send(struct p1905_managerd_ctx *ctx, unsigned short msg_type,
		unsigned short mid, int ifidx);
#endif


#endif /* CMDU_H */
