/*
 * bridge_parse.c: reserve for parse bridge layer
 *
 * Author: Sirui Zhao <Sirui.Zhao@mediatek.com>
 */
#include <net/if.h>
#include <linux/in6.h>
#include <linux/if_bridge.h>
#include <stdio.h>
#include <string.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <unistd.h>

#ifndef MAX_FDBS
#define MAX_FDBS 512
#endif

static void arm_ioctl(unsigned long *args,
		unsigned long arg0, unsigned long arg1, unsigned long arg2)
{
	args[0] = arg0;
	args[1] = arg1;
	args[2] = arg2;
	args[3] = 0;
}

static int judge_mac(char *mac, int len)
{
        int i,ret;

        ret = 0;
        for (i=0; i<len; i++) {
                if (mac[i] == '\0')
                        ret += 1;
                if (ret == len)
                        ret = -1;
        }
        return ret;
}

/*According the interface name to search the bridge forward data table
 to find the specific entries*/
int bridge_search_fdb_table(char *br)
{
		int fd, ret, j=0;
        struct ifreq ifr;
		char ifname[IFNAMSIZ];
        struct __fdb_entry entries[MAX_FDBS];


        unsigned long args[4];
        ifr.ifr_data = (char *) &args;
        strncpy(ifr.ifr_name, br, IFNAMSIZ);
		fd = socket(AF_INET, SOCK_STREAM, 0);

        if (fd < 0) {
                printf("brctl(map) socket error!\n");
                return fd;
        }

        arm_ioctl(args, BRCTL_GET_FDB_ENTRIES, (unsigned long)entries, MAX_FDBS);
        ret = ioctl(fd, SIOCDEVPRIVATE, &ifr);
        if (ret < 0) {
                printf("brctl(map) ioctl error!\n");
                return ret;
        }
        printf("----------------------Bridge FDB TABLE------------------------\n");
        printf("index\tunused\tlocal\tPort_no_name\tage-time\tmac\n");
        for (j = 0; j < MAX_FDBS; j++) {
                if (entries[j].unused != 0 || entries[j].ageing_timer_value==0
                        || (judge_mac((char*)(entries[j].mac_addr),6) < 0))
                        continue;
                if (!if_indextoname(entries[j].port_no, ifname))
						continue;
                printf("%d\t%d\t%d\t%x-%s\t\t%d\t\t%02x:%02x:%02x:%02x:%02x:%02x\n",j,
                                                entries[j].unused,
                                                entries[j].is_local,
                                                entries[j].port_no,
                                                ifname,
                                                entries[j].ageing_timer_value,
                                                entries[j].mac_addr[0],
                                                entries[j].mac_addr[1],
                                                entries[j].mac_addr[2],
                                                entries[j].mac_addr[3],
                                                entries[j].mac_addr[4],
                                                entries[j].mac_addr[5]);
        }
		close(fd);
        return 0;
}