/*
 ***************************************************************************
 *  Mediatek Inc.
 * 4F, No. 2 Technology 5th Rd.
 * Science-based Industrial Park
 * Hsin-chu, Taiwan, R.O.C.
 *
 * (c) Copyright 2002-2011, Mediatek, Inc.
 *
 * All rights reserved. Mediatek's source code is an unpublished work and the
 * use of a copyright notice does not imply otherwise. This source code
 * contains confidential trade secret material of Ralink Tech. Any attemp
 * or participation in deciphering, decoding, reverse engineering or in any
 * way altering the source code is stricitly prohibited, unless the prior
 * written consent of Mediatek, Inc. is obtained.
 ***************************************************************************

	Module Name:
	wdev_sta.c

	Abstract:

	Revision History:
	Who         When          What
	--------    ----------    ----------------------------------------------
*/

#include <stdlib.h>
#include <stdio.h>
#include "wdev.h"
#include "driver_wext.h"

int wdev_sta_del(struct wifi_app	*wapp, struct wapp_dev	*wdev);

struct wdev_ops wdev_sta_ops = {
	.wdev_del = wdev_sta_del,
};


int wdev_sta_create(
	struct wifi_app *wapp,
	wapp_dev_info *dev_info)
{
	struct wapp_dev *wdev = NULL;
	struct wapp_sta *sta = NULL;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	if (!wapp || !dev_info) {
		return WAPP_INVALID_ARG;
	}

	wdev = wapp_dev_list_lookup_by_ifindex(wapp, dev_info->ifindex);	

	if (wdev == NULL)
		goto new_wdev;
	else if (wdev->p_dev == NULL)
		goto new_sta;
	else if (wdev->dev_type != WAPP_DEV_TYPE_STA && wdev->dev_type != WAPP_DEV_TYPE_STA /* remove APCLI*/) {
		DBGPRINT_RAW(RT_DEBUG_OFF, "Error! dev_type = %u\n", wdev->dev_type);
		/* check duplicate mac_address? */
		return WAPP_UNEXP;
	} else {
		/* already exsist */
		return WAPP_SUCCESS;
	}

new_wdev:
	if (wapp_dev_create(wapp, (char *) dev_info->ifname, dev_info->ifindex, dev_info->mac_addr) != WAPP_SUCCESS)
		DBGPRINT_RAW(RT_DEBUG_OFF, "Warning! wdev create failed.\n");
	return WAPP_SUCCESS;

new_sta:
	wdev->p_dev = os_zalloc(sizeof(struct wapp_sta));

	if (!wdev->p_dev)
		return WAPP_RESOURCE_ALLOC_FAIL;

	sta = wdev->p_dev;
	os_memset(sta, 0, sizeof(struct wapp_sta));
	dl_list_init(&sta->non_pref_ch_list); 
	wdev->ops = &wdev_sta_ops;

	wdev->dev_type = WAPP_DEV_TYPE_STA;
	wdev->radio = wapp_radio_update_or_create(wapp,
						dev_info->adpt_id,
						dev_info->radio_id);

	if (!wdev->radio) {
		DBGPRINT_RAW(RT_DEBUG_OFF, "Warning! radio not found.\n");
	}

	wdev->wireless_mode = dev_info->wireless_mode;
	wdev->valid = 1;
	return WAPP_SUCCESS;
}

int wdev_sta_del(
struct wifi_app	*wapp,
struct wapp_dev	*wdev)
{
	struct wapp_sta *sta = NULL;

	DBGPRINT(RT_DEBUG_TRACE, "%s\n", __func__);
	if (!wapp || !wdev) {
		return WAPP_INVALID_ARG;
	}

	sta = (struct wapp_sta *) wdev->p_dev;

	/* free sta */
	os_free(sta);
	wdev->p_dev = NULL;

	return WAPP_SUCCESS;
}

